/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import com.rcx.materialis.util.TinkerToolFluxed;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class CapacitorModifier
extends Modifier {
    public ValidatedResult validate(IToolStackView tool, int level) {
        int max = tool.getVolatileData().getInt(TinkerToolFluxed.MAX_ENERGY);
        if (tool.getPersistentData().getInt(TinkerToolFluxed.STORED_ENERGY) > max) {
            tool.getPersistentData().putInt(TinkerToolFluxed.STORED_ENERGY, max);
        }
        return ValidatedResult.PASS;
    }

    public void onRemoved(IToolStackView tool) {
        if (tool.getVolatileData().getInt(TinkerToolFluxed.MAX_ENERGY) == 0) {
            tool.getPersistentData().remove(TinkerToolFluxed.STORED_ENERGY);
        }
    }

    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        if (volatileData.contains(TinkerToolFluxed.MAX_ENERGY, 3)) {
            volatileData.putInt(TinkerToolFluxed.MAX_ENERGY, volatileData.getInt(TinkerToolFluxed.MAX_ENERGY) + this.getCapacity() * level);
        } else {
            volatileData.putInt(TinkerToolFluxed.MAX_ENERGY, this.getCapacity() * level);
        }
        if (!volatileData.contains(TinkerToolFluxed.ENERGY_OWNER, 8)) {
            volatileData.putString(TinkerToolFluxed.ENERGY_OWNER, this.getId().toString());
        }
    }

    public void addInformation(IToolStackView tool, int level, Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        if (tool instanceof ToolStack && this.isOwner(tool.getVolatileData())) {
            tooltip.add((Component)new TranslatableComponent("tooltip.materialis.stored_enegry", new Object[]{tool.getPersistentData().getInt(TinkerToolFluxed.STORED_ENERGY), tool.getVolatileData().getInt(TinkerToolFluxed.MAX_ENERGY)}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)this.getColor()))));
        }
    }

    public int getCapacity() {
        return 10000;
    }

    public boolean isOwner(IModDataView volatileData) {
        return this.getId().toString().equals(volatileData.getString(TinkerToolFluxed.ENERGY_OWNER));
    }
}

